10 rem **********************************************************
20 rem * window.bas
30 rem **********************************************************
40 rem * (c) 1995 Gerrit Polder, PA3BYA
50 rem * version 1.0
60 rem *
70 rem * nonrecursive filter design by fourier transform method
80 rem * with rectangular, von hann, or hamming window
90 rem * and decibel plot of frequency responce magnitude
100 rem * with output to TI DSK source file
110 rem * adapted from:
120 rem *       Paul A. Lynn and Wolfgang Fuerst
130 rem *       Introductory Digital Signal Processing
140 rem **********************************************************
150 rem * history:
160 rem * 4/3/95 created
170 rem **********************************************************
180 dim see(200),h(200),w(300)
190 filename$ = "coeff.asm"
200 input "Enter sample-frequency: ";s
210 s = s/2 : rem shannon
220 input "Enter center-frequency: ";centerf
230 w0 = centerf*pi/s
240 input "Enter filter bandwidth: ";bwidth
250 w1 = bwidth*0.5*pi/s
260 input "Enter number of taps: ";taps
270 if taps/2 <> int(taps/2) then print "even number please" : goto 260
280 m = taps/2
290 print "Select window:"
300 print "0=rectangular; 1=Von Hann; 2= Hamming: "; : get x$ : x = val(x$) : cls
310 rem
320 rem *************** compute window values ********************
330 if x = 0 then a = 1 : b = 0 : c = 1 : goto 360
340 if x = 1 then a = 0.5 : b = 0.5 : c = m+1 : goto 360
350 a = 0.54 : b = 0.46 : c = m
360 for n = 1 to m : see(n) = a+b*cos(n*pi/c) : next n
370 rem
380 rem ********** compute impulse responce values ***************
390 h0 = w1/pi : for n = 1 to m
400 h(n) = (1/(n*pi))*sin(n*w1)*cos(n*w0)*see(n) : next n
410 rem
420 rem ****** draw grid and requested frequency responce ********
430 graphics 0
440 graphics color 0,0,100
450 minw = w0*300/pi-w1*300/pi : if minw < 0 then minw = 0
460 maxw = w0*300/pi+w1*300/pi : if maxw > 300 then maxw = 300
470 graphics fillrect minw+20,30,maxw+20,170,4
480 graphics color 0,0,0
490 for k = 0 to 7
500     moveto 20,30+20*k : lineto 320,30+20*k
510     moveto 1,35+20*k : graphics drawtext str$(10*k,2)
520 next k
530 for k = 1 to 4
540     moveto 60*k+20,30 : lineto 60*k+20,170
550     freq$ = str$(int(k*s/5))
560     moveto 60*k+20-(len(freq$)*4),185 : graphics drawtext freq$
570 next k
580 moveto 20,30 : lineto 20,170 : moveto 319,30 : lineto 319,170
590 moveto 16,185 : graphics drawtext "0"
600 freq$ = str$(int(s)) : moveto 320-(len(freq$)*8),185 : graphics drawtext freq$
610 rem
620 rem ********** compute frequency responce *********************
630 for n = 1 to 300 : freq = pi*(n-1)/300
640 w(n) = h0 : for k = 1 to m : w(n) = w(n)+2*h(k)*cos(k*freq) : next k
650 next n
660 rem
670 rem ***** normalise to unity, convert to decibels, and plot ***
680 max = 0 : for n = 1 to 300 : if abs(w(n)) > max then max = abs(w(n))
690 next n
700 graphics color 100,0,0
710 moveto 20,170
720 for n = 1 to 300
730     db = 20*log(abs(w(n))/max)*0.4343 : if db < -70 then db = -70
740     lineto n+20,30-2*db
750 next n
760 rem
770 rem ************ save coefficients in output file *************
780 print "Press <return> to save coefficients in ";filename$;
790 get dummy$
800 open filename$ for output as #1
810 print #1,"* coefficents file written by window.bas"
820 print #1,"* (c) 1995 G. Polder, PA3BYA"
830 print #1,"*",date$,time$
840 print #1,"*"
850 print #1,"* sample frequency: ",s*2
860 print #1,"* center frequency: ",centerf
870 print #1,"* bandwidth: ",bwidth
880 if x = 0 then print #1,"* window type: rectangular"
890 if x = 1 then print #1,"* window type: Von Hann"
900 if x = 2 then print #1,"* window type: Hamming"
910 print #1,"* number of taps: ",taps
920 print #1,"*"
930 print #1,"* impulse responce:"
940 for n = 1 to m
950     print #1,"* h(";str$(n-1,3);") = ";str$(h(m-(n-1))/max,13);
960     print #1," = h(";str$(taps-n,3);")"
970 next n
980 print #1,"*"
990 print #1,"* setting of filtersize"
1000 print #1,"FILT_SIZE   .set      ";taps
1010 print #1,"*"
1020 print #1,"* filter coefficients"
1030 for n = 1 to m : h(n) = int(h(n)*32768/max) : next n
1040 for n = 1 to m
1050     h$ = "h"+str$(n-1)+"    "
1060     print #1,left$(h$,4);"       .word   ";str$(h(m-(n-1)),6)
1070 next n
1080 for n = 1 to m-1
1090     h$ = "h"+str$(m+n-1)+"    "
1100     print #1,left$(h$,4);"       .word   ";str$(h(n),6)
1110 next n
1120     print #1,"H_LAST     .word   ";str$(h(m),6)
1130 print #1,"*"
1140 print #1,"* data locations for stage delay line"
1150 i = 0
1160 while i <> taps-1
1170     print #1,"XN";int(i/10);"       .word     ";
1180     for n = 1 to 10 : print #1,"0";
1190         i = i+1
1200         if i = taps-1 then 1240
1210         if n <> 10 then print #1,",";
1220     next n
1230     print #1,""
1240 wend
1250 print #1,""
1260 print #1,"XNLAST     .word      0"
1270 close #1
1280 print "" : print "Ready"
1290 rem *********************** the end **************************
